package gov.va.vinci.dart.biz;

import gov.va.vinci.dart.common.SingletonShim;
import gov.va.vinci.dart.common.test.BusinessIntegrationTest;
import gov.va.vinci.dart.service.DartObjectFactory;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class TestActivity extends BusinessIntegrationTest {
	@BeforeTest
	public void setup() {
		SingletonShim.getBean(DartObjectFactory.class);
	}

	@Test
	public void testOne() throws Exception {
		Assert.assertNull(ResearchStudy.findById(0));
		
		ResearchStudy study = ResearchStudy.create("short name", new Date(), new Date(), "Official Name - this is a test!", "DNS");
		Assert.assertNotNull(study);
		Assert.assertTrue(study.getId() > 0);
		
		int activityId = study.getId();
		
		Activity activity = Activity.findById(activityId);
		Assert.assertNotNull(activity);
		Assert.assertTrue(activity.getId() > 0);
		Assert.assertEquals(activity, study);
	}

	@Test
	public void testTwo() throws Exception {
		Assert.assertNull(ResearchStudy.findById(0));

		Activity rs = ResearchStudy.findById(1);
		Assert.assertNotNull(rs);
		Assert.assertEquals(rs.getId(), 1);
		Assert.assertNotNull(rs.getRequests());
		Assert.assertTrue(rs.getRequests().size() > 0);

		Assert.assertNotNull(rs.getStartDate());
		Assert.assertNotNull(rs.getEndDate());
		Assert.assertNotNull(rs.getOfficialName());

		Request req = rs.getRequests().iterator().next();
		Assert.assertNotNull(req);
		
		Assert.assertEquals(rs.getFirstRequest(), req);
		Assert.assertEquals(rs.getCurrentRequest(), req);
		
		Person pers = Person.findById(1006);
		
		DartRequest req2 = DartRequest.create("test request 2", new Date(), new Date(), pers, rs, "DNS");

		Assert.assertNotNull(req2);
		Assert.assertTrue(req2.getId() > 0);
		Assert.assertNotEquals(req2, req);

		// don't have to call addRequest
		
		Assert.assertEquals(req.getActivity(), rs);
		Assert.assertTrue(rs.getRequests().contains(req));
		Assert.assertTrue(rs.getRequests().contains(req2));

		List<String> slist = new ArrayList<String>();
		rs.validate(slist);
		
		Assert.assertNotNull(slist);
		Assert.assertEquals(slist.size(), 0);

	}

}
